"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "refreshChildRecordsForSync", {
    enumerable: true,
    get: function() {
        return refreshChildRecordsForSync;
    }
});
const _lodash = require("lodash");
const _database = require("@tamanu/database");
const _constants = require("@tamanu/constants");
async function refreshChildRecordsForSync(model, instanceId) {
    const dependantAssociations = (0, _database.getDependentAssociations)(model);
    for (const association of dependantAssociations){
        const { target, foreignKey } = association;
        if (target.syncDirection === _constants.SYNC_DIRECTIONS.DO_NOT_SYNC) {
            continue;
        }
        // We need to go via a raw query as Model.update({}) performs validation on the
        // whole record, so we'll be rejected for failing to include required fields -
        // even though we only want to update updated_at_sync_tick!
        const [updatedRows] = await model.sequelize.query(`
        UPDATE ${target.tableName}
        SET updated_at_sync_tick = 1
        WHERE ${(0, _lodash.snakeCase)(foreignKey)} = :instanceId
        RETURNING id;
      `, {
            replacements: {
                instanceId
            }
        });
        // If there are any child records, also recursively update them
        // so that they are also updated in the sync_lookup table
        // eg: if survey_response is updated, we must also updated survey_response_answers
        for (const updatedRow of updatedRows){
            await refreshChildRecordsForSync(target, updatedRow.id);
        }
    }
}

//# sourceMappingURL=refreshChildRecordsForSync.js.map