"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getReferenceDataOptionStringId: function() {
        return getReferenceDataOptionStringId;
    },
    getReferenceDataStringId: function() {
        return getReferenceDataStringId;
    }
});
const _constants = require("@tamanu/constants");
/**
 * Replace any spaces, dots, and semicolons with underscores (dots are the delimiter in translation ids, and semicolons are invalid)
 *
 * @example "hello world" → "hello_world"
 * @example "test.value" → "test_value"
 * @example "hello.world test" → "hello_world_test"
 * @example "hello;world test" → "hello_world_test"
 */ const formatOptionForStringId = (str)=>`${str}`.replace(/[\s.;]/g, '_');
const getReferenceDataOptionStringId = (value, category, option)=>{
    const baseStringId = `${getReferenceDataStringId(value, category)}.option`;
    return `${baseStringId}.${formatOptionForStringId(option)}`;
};
const getReferenceDataStringId = (value, category)=>{
    return `${_constants.REFERENCE_DATA_TRANSLATION_PREFIX}.${category}.${value}`;
};

//# sourceMappingURL=getReferenceDataStringId.js.map