import React from 'react';
import { Col, Row, VDSImage } from './Layout';
import { P } from './Typography';
import { getDobWithAge, getNationality, getPassportNumber } from '../patientAccessors';
import { useLanguageContext } from '../pdf/languageContext';
const PATIENT_FIELDS = [
    {
        key: 'firstName',
        label: 'First name'
    },
    {
        key: 'lastName',
        label: 'Last name'
    },
    {
        key: 'dateOfBirth',
        label: 'Date of birth',
        accessor: getDobWithAge
    },
    {
        key: 'sex',
        label: 'Sex'
    },
    {
        key: 'displayId',
        label: 'NHN'
    },
    {
        key: 'passport',
        label: 'Passport number',
        accessor: getPassportNumber
    },
    {
        key: 'nationality',
        label: 'Nationality',
        accessor: getNationality
    }
];
export const CovidPatientDetailsSection = ({ patient, getLocalisation, getSetting, vdsSrc, extraFields = [], uvci })=>{
    const { getTranslation } = useLanguageContext();
    const detailsToDisplay = [
        ...PATIENT_FIELDS,
        ...extraFields
    ].filter(({ key })=>!getSetting(`fields.${key}.hidden`));
    const leftWidth = vdsSrc ? 66 : 88;
    const rightWidth = 100 - leftWidth;
    return /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(Col, {
        style: {
            width: `${leftWidth}%`
        }
    }, /*#__PURE__*/ React.createElement(Row, null, detailsToDisplay.map(({ key, label: defaultLabel, accessor })=>{
        const value = accessor?.(patient, {
            getLocalisation,
            getTranslation,
            getSetting
        }) ?? (patient[key] || '');
        const label = getTranslation(`general.localisedField.${key}.label.short`) || getTranslation(`general.localisedField.${key}.label`) || defaultLabel;
        return /*#__PURE__*/ React.createElement(Col, {
            key: key
        }, /*#__PURE__*/ React.createElement(P, {
            mb: 5
        }, /*#__PURE__*/ React.createElement(P, {
            bold: true
        }, label, ":"), " ", value));
    })), uvci && /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(P, null, /*#__PURE__*/ React.createElement(P, {
        bold: true
    }, "UVCI:"), " ", uvci))), /*#__PURE__*/ React.createElement(Col, {
        style: {
            width: `${rightWidth}%`
        }
    }, vdsSrc && /*#__PURE__*/ React.createElement(VDSImage, {
        src: vdsSrc
    })));
};

//# sourceMappingURL=CovidPatientDetailsSection.js.map