"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    FAKE_UUID_PATTERN: function() {
        return FAKE_UUID_PATTERN;
    },
    fakeUUID: function() {
        return fakeUUID;
    },
    generateId: function() {
        return generateId;
    },
    generateIdFromPattern: function() {
        return generateIdFromPattern;
    },
    isGeneratedDisplayId: function() {
        return isGeneratedDisplayId;
    },
    isGeneratedIdFromPattern: function() {
        return isGeneratedIdFromPattern;
    }
});
const _uuid = require("uuid");
const generators = {
    A: ()=>String.fromCharCode(65 + Math.floor(Math.random() * 26)),
    '0': ()=>Math.floor(Math.random() * 10).toFixed(0)
};
const DISPLAY_ID_FORMAT = 'AAAA000000';
const isGeneratedDisplayId = (displayId)=>{
    if (DISPLAY_ID_FORMAT !== 'AAAA000000') return false;
    return /^[A-Z]{4}\d{6}$/.test(displayId);
};
/*
 * This regex is used to match each token in the pattern.
 * It will match groups of characters wrapped in [] or single A or 0.
 */ const PATTERN_TOKEN_REGEX = /(\[.+?\])(?=\[|[A0]|$)|[A0]/g;
const tokenAsRegex = (token)=>{
    if (token.startsWith('[') && token.endsWith(']')) {
        // Escape special characters in the token to use in a regex
        return token.slice(1, -1).replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
    }
    if (token === 'A') {
        return '[A-Z]';
    }
    if (token === '0') {
        return '[0-9]';
    }
    throw new Error(`Invalid token: ${token}`);
};
const generateIdFromPattern = (pattern)=>pattern.replace(PATTERN_TOKEN_REGEX, (token)=>{
        if (token.startsWith('[') && token.endsWith(']')) {
            return token.slice(1, -1);
        }
        return generators[token]?.() ?? '';
    });
const generateId = ()=>generateIdFromPattern(DISPLAY_ID_FORMAT);
const isGeneratedIdFromPattern = (displayId, pattern)=>{
    const patternTokens = pattern.match(PATTERN_TOKEN_REGEX);
    if (!patternTokens) return false;
    const expression = patternTokens.reduce((acc, token)=>acc + tokenAsRegex(token), '');
    const patternRegex = new RegExp(`^${expression}$`);
    return patternRegex.test(displayId);
};
const fakeUUID = ()=>{
    return (0, _uuid.v4)().replace(/(.{8}-.{4})-.{4}-(.+)/, '$1-0000-$2');
};
const FAKE_UUID_PATTERN = '________-____-0000-____-____________';

//# sourceMappingURL=generateId.js.map